#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>

using namespace std;

const int INF = 1e9;

int main() {
    int N;
    cin >> N;

    vector<vector<int>> graph(N + 1);
    vector<int> hasPlatform(N + 1);
    vector<int> changeState(N + 1);

    // Ucitavanje grafa
    for (int i = 1; i < N; ++i) {
        int U, V;
        cin >> U >> V;
        graph[U].push_back(V);
        graph[V].push_back(U);
    }

    // Ucitavanje informacija o platformama
    for (int i = 1; i <= N; ++i) {
        cin >> hasPlatform[i];
    }

    // Ucitavanje informacija o promeni stanja
    for (int i = 1; i <= N; ++i) {
        cin >> changeState[i];
    }

    // BFS za pronalaženje najmanjeg broja skokova za svakog zeca
    vector<int> minJumps(N + 1, INF);
    queue<int> q;

    q.push(1);  // Zec 1 krece iz prve sobe
    minJumps[1] = 0;

    while (!q.empty()) {
        int currentRoom = q.front();
        q.pop();

        for (int nextRoom : graph[currentRoom]) {
            if (minJumps[nextRoom] == INF) {
                // Ako može skociti na sobu, dodajemo joj trenutnu snagu zeca
                if (hasPlatform[nextRoom]) {
                    minJumps[nextRoom] = minJumps[currentRoom] + 1;
                    q.push(nextRoom);
                }
                // Ako može doskociti na sobu bez platforme, dodajemo snagu zeca ili menjamo stanje sobe
                else if (minJumps[currentRoom] + 1 <= changeState[nextRoom]) {
                    minJumps[nextRoom] = minJumps[currentRoom] + 1;
                    q.push(nextRoom);
                }
            }
        }
    }

    // Ispis rezultata
    for (int i = 1; i <= N; ++i) {
        if (minJumps[i] == INF) {
            cout << -1 << " ";
        } else {
            cout << minJumps[i] << " ";
        }
    }

    return 0;
}